package com.dtyunxi.yundt.cube.center.inventory.enums;

/**
 * @see com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto#getSourceType()
 * @author jack
 * @version 1.0
 * @date 07/09/2022 10:24
 **/
public enum AdjustSourceTypeEnum {
    /**
     * 调整单来源
     */
    TRANSFER_ORDER("in_transit_adjustment", "在途调拨单"),
    DELIVER_RESULT("deliverResult", "发货结果单"),
    RECEIVE_RESULT("receiveResult", "收货结果单"),
    ;

    private final String type;
    private final String desc;

    AdjustSourceTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
