package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 调整单类型：check_stock-盘点单，in_transit_adjustment-在途库存调整单
 *
 * @author jinger
 * @version 1.0
 */
public enum CsAdjustmentOrderTypeEnum {
    /**
     * 盘点单
     **/
    CHECK_STOCK("check_stock", "盘点单"),
    /**
     * 在途库存调整单
     **/
    IN_TRANSIT_ADJUSTMENT("in_transit_adjustment", "在途库存调整单"),
    ;

    private String code;

    private String desc;

    CsAdjustmentOrderTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code 编码
     * @return 枚举
     */
    public static CsAdjustmentOrderTypeEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.stream(CsAdjustmentOrderTypeEnum.values()).filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }
}
