package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 对外对接策略枚举
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/12 1:44 下午
 */
public enum CsBasicsExternalStrategyEnum {

    /**
     * wms
     **/
    WMS("wms", "wms"),

    /**
     * eas
     **/
    EAS("eas", "eas"),
    ;
    private String code;

    private String desc;

    CsBasicsExternalStrategyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsBasicsExternalStrategyEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsBasicsExternalStrategyEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }
}
