package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 标准单据初始状态枚举
 *
 * @author jinger
 * @version 1.0
 */
public enum CsBasicsOrderNextStatusEnum {

    /**
     * 发货通知单
     **/
    DELIVERY_NOTICE_ORDER(CsBasicsOrderStrategyEnum.RECEIVE_DELIVERY_NOTICE_ORDER.getCode(),
            CsBasicsOrderOperateTypeEnum.DELIVERY.getCode(), CsOrderStatusEnum.DNO_WAIT_DELIVERY.getCode()),

    /**
     * 发货通知单
     **/
    RECEIVE_NOTICE_ORDER(CsBasicsOrderStrategyEnum.RECEIVE_DELIVERY_NOTICE_ORDER.getCode(),
            CsBasicsOrderOperateTypeEnum.RECEIVE.getCode(), CsOrderStatusEnum.RNO_WAIT_RECEIVE.getCode()),
    /**
     * 出库通知单
     **/
    OUT_NOTICE_ORDER(CsBasicsOrderStrategyEnum.IN_OUT_NOTICE_ORDER.getCode(),
            CsBasicsOrderOperateTypeEnum.OUT.getCode(), CsOrderStatusEnum.ONO_WAIT_OUT.getCode()),
    /**
     * 入库通知单
     **/
    IN_NOTICE_ORDER(CsBasicsOrderStrategyEnum.IN_OUT_NOTICE_ORDER.getCode(),
            CsBasicsOrderOperateTypeEnum.IN.getCode(), CsOrderStatusEnum.INO_WAIT_IN.getCode());
    private String strategy;

    private String basicsOrderOperateType;

    private String orderStatus;

    CsBasicsOrderNextStatusEnum(String strategy, String basicsOrderOperateType, String orderStatus) {
        this.strategy = strategy;
        this.basicsOrderOperateType = basicsOrderOperateType;
        this.orderStatus = orderStatus;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getBasicsOrderOperateType() {
        return basicsOrderOperateType;
    }

    public void setBasicsOrderOperateType(String basicsOrderOperateType) {
        this.basicsOrderOperateType = basicsOrderOperateType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public static CsBasicsOrderNextStatusEnum getInitStatus(String strategy, String basicsOrderOperateType) {
        if (StringUtils.isBlank(strategy)||StringUtils.isBlank(basicsOrderOperateType)) {
            return null;
        }
        return Arrays.asList(CsBasicsOrderNextStatusEnum.values()).stream().filter(eo -> strategy.equals(eo.getStrategy())&&basicsOrderOperateType.equals(eo.getBasicsOrderOperateType())).findAny().orElse(null);
    }
}
