package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 库存出入库标识
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsBasicsOrderOperateTypeEnum {

    /**
     * 收货
     **/
    RECEIVE("RECEIVE", "收货"),
    /**
     * 发货
     **/
    DELIVERY("DELIVERY", "发货"),
    /**
     * 入库
     **/
    IN("IN", "入库"),
    /**
     * 出库
     **/
    OUT("OUT", "出库"),
    ;

    private String code;

    private String desc;

    CsBasicsOrderOperateTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsBasicsOrderOperateTypeEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsBasicsOrderOperateTypeEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }
}
