package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 基础单据策略枚举
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/12 1:44 下午
 */
public enum CsBasicsOrderStrategyEnum {

    /**
     * 收发货通知单
     **/
    RECEIVE_DELIVERY_NOTICE_ORDER("receiveDeliveryNoticeOrder", "收发货通知单"),

    /**
     * 出入库通知单
     **/
    IN_OUT_NOTICE_ORDER("inOutNoticeOrder", "出入库通知单"),

    /**
     * 收发货结果单
     **/
    RECEIVE_DELIVERY_RESULT_ORDER("receiveDeliveryResultOrder", "收发货结果单"),

    /**
     * 出入库结果单
     **/
    IN_OUT_RESULT_ORDER("inOutResultOrder", "出入库结果单"),

    ;
    private String code;

    private String desc;

    CsBasicsOrderStrategyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsBasicsOrderStrategyEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsBasicsOrderStrategyEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }
}
