package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 批次调整单业务类型枚举
 *
 * @author 温仪
 * @version 1.0
 * @Date 2022/4/20 3:38 下午
 */
public enum CsBatchAdjustmentOrderBusinessTypeEnum {
    /**
     * 采购单据
     **/
    GENERAL_ADJUSTMENT("general_adjustment", "普通调整"),
    ;

    private String code;

    private String desc;

    CsBatchAdjustmentOrderBusinessTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsBatchAdjustmentOrderBusinessTypeEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsBatchAdjustmentOrderBusinessTypeEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }
}
