package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 单据状态：wait_submit：待提交、wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：审核不通过
 *
 * @author 温仪
 * @version 1.0
 * @Date 2022/4/20 5:38 下午
 */
public enum CsBatchAdjustmentOrderStatusEnum {

    /**
     * 待提交
     **/
    WAIT_SUBMIT("wait_submit", "待提交"),
    /**
     * 待审核
     **/
    WAIT_AUDIT("wait_audit", "待审核"),
    /**
     * 审核不通过
     **/
    AUDIT_FAILED("audit_failed", "审核不通过"),
    /**
     * 已取消
     **/
    CANCEL("cancel", "已取消"),
    /**
     * 已完成
     **/
    COMPLETED("completed", "已完成"),

    ;

    private String code;

    private String desc;

    CsBatchAdjustmentOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (CsBatchAdjustmentOrderStatusEnum value : CsBatchAdjustmentOrderStatusEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return StringUtils.EMPTY;
    }
}
