package com.dtyunxi.yundt.cube.center.inventory.enums;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * 库存出入库标识
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsBusinessCallBackStrategyEnum {

    /**
     * 采购、委外、生产单据
     **/
    PLANNED_ORDER("planned_order", Lists.newArrayList(CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode()
            ,CsRelevanceTableNameEnum.CS_OUT_PLANNED_ORDER.getCode()),"采购、委外、生产单据"),
    /**
     * 其他出入库单据
     **/
    OTHER_IN_OUT("other_in_out",Lists.newArrayList(CsRelevanceTableNameEnum.CS_OTHER_STORAGE_ORDER.getCode()), "其他出入库单据"),
    /**
     * 调拨单
     **/
    TRANSFER_ORDER("transfer_order",Lists.newArrayList(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode()), "调拨单"),
    /**
     * 销售退单
     **/
    ORDER_SALE_REFUND("order_sale_refund",Lists.newArrayList(CsRelevanceTableNameEnum.CS_ORDER_SALE_REFUND.getCode()), "销售退单"),
    /**
     * 批次调整单
     **/
    BATCH_ADJUSTMENT_ORDER("batch_adjustment_order", Lists.newArrayList(CsRelevanceTableNameEnum.CS_BATCH_ADJUSTMENT_ORDER.getCode()), "批次调整单据"),
    /**
     * 销售单相关
     **/
    CS_ORDER_SALE("order_sale",Lists.newArrayList(CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode()), "销售单相关"),

    CS_ADJUSTMENT_ORDER("batch_adjustment_order", Lists.newArrayList(CsRelevanceTableNameEnum.CS_ADJUSTMENT_ORDER.getCode()), "调整单"),

    ;

    private String code;

    private List<String> tableNameList;

    private String desc;

    CsBusinessCallBackStrategyEnum(String code,List<String> tableNameList, String desc) {
        this.code = code;
        this.tableNameList = tableNameList;
        this.desc = desc;
    }

    public List<String> getTableNameList() {
        return tableNameList;
    }

    public void setTableName(List<String> tableNameList) {
        this.tableNameList = tableNameList;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsBusinessCallBackStrategyEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsBusinessCallBackStrategyEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }

    /**
     * 根据业务表名获取枚举
     *
     * @param tableName
     * @return
     */
    public static CsBusinessCallBackStrategyEnum getByTableName(String tableName) {
        if (StringUtils.isBlank(tableName)) {
            return null;
        }
        return Arrays.asList(CsBusinessCallBackStrategyEnum.values()).stream().filter(eo -> eo.tableNameList.contains(tableName)).findAny().orElse(null);
    }

}
