package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 串码读取状态枚举
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 2:44 下午
 */
public enum CsCargoIdentityCodeEnum {

    /** 已读取未完整 **/
    READ_DEFICIENCY("pulled_deficiency","已读取未完整"),

    /** 已读取完整 **/
    READ_COMPLETION("pulled_completion","已读取完整"),

    /** 不读取 **/
    UN_PULLED("un_pulled","出库结果单"),

    /** 未读取(待读取) **/
    WAIT_PULLED("wait_pulled","未读取(待读取)"),
    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsCargoIdentityCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsCargoIdentityCodeEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsCargoIdentityCodeEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
