package com.dtyunxi.yundt.cube.center.inventory.enums;

/**
 * 库存出入库标识
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsChangeTypeEnum {

    /**
     * 总库存变动
     **/
    BLANCE("blance", "总库存变动"),

    /**
     * 预占库存变动
     **/
    PREEMPT("preempt", "预占库存变动"),

    /**
     * 已分配库存
     **/
    ALLOCATE("allocate", "已分配库存"),
    
    /**
     * 活动分配库存
     **/
    ACTIVITY_ALLOCATE("activity_allocate", "活动分配库存"),

    /**
     * 在途库存
     **/
    INTRANSIT("intransit", "在途库存"),

    /**
     * 已调拨库存
     **/
    TRANSFER("transfer", "已调拨库存"),

    /**
     * 已完成库存
     **/
    COMPLETED("completed", "已完成库存"),

    /**
     * 可用库存
     **/
    AVAILABLE("available", "可用库存"),

    ;

    private String code;

    private String desc;

    CsChangeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
