package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 单据编码生成的前缀枚举
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 7:20 下午
 */
public enum CsDocumentCodePrefixEnum {

    /**
     * COMMON
     **/
    COMMON("COMMON", "普通"),

    /**
     * 发货通知单
     **/
    DON("DON", "发货通知单"),
    /**
     * 在途发货通知单
     **/
    ZTDON("ZTDON", "在途发货通知单"),

    /**
     * 出库通知单
     **/
    PDON("PDON", "出库通知单"),

    /**
     * 出库结果单
     **/
    PSR("PSR", "出库结果单"),

    /**
     * 发货结果单
     **/
    DS("DS", "发货结果单"),
    /**
     * 在途发货结果单
     **/
    ZTDS("ZTDS", "在途发货结果单"),

    /**
     * 收货通知单
     **/
    GRN("GRN", "收货通知单"),
    /**
     * 在途收货通知单
     **/
    ZTGRN("ZTGRN", "在途收货通知单"),

    /**
     * 入库通知单
     **/
    PASN("PASN", "入库通知单"),

    /**
     * 入库结果单
     **/
    PRO("PRO", "入库结果单"),

    /**
     * 收货结果单
     **/
    RS("RS", "收货结果单"),
    /**
     * 在途收货结果单
     **/
    ZTRS("ZTRS", "在途收货结果单"),

    /**
     * 逻辑仓库
     **/
    LOGIC_WAREHOUSE("L", "逻辑仓库"),

    /**
     * 物理仓库
     **/
    PHYSICS_WAREHOUSE("P", "物理仓库"),

    /**
     * 采购订单
     **/
    CG("CG", "采购订单"),
    /**
     * 采购订单退货
     **/
    CT("CT", "采购订单退货"),

    /**
     * 委外订单
     **/
    WW("WW", "委外订单"),

    /**
     * 委外订单退货
     **/
    WWTH("WWTH", "委外订单退货"),

    /**
     * 生产订单
     **/
    SC("SC", "生产订单"),

    /**
     * 生产返修订单
     **/
    SCFX("SCFX", "生产返修订单"),

    /**
     * 批次调整单
     **/
    BNA("BNA", "批次调整单"),

    /**
     * 盘点单
     **/
    TS("TS", "盘点单"),

    /**
     * 待检转合格
     **/
    DJZ("DJZ", "待检转合格"),

    /**
     * 其他出入库单
     **/
    QT("QT", "其他出入库单"),

    /**
     * 其他出库单
     **/
    QTCK("QTCK", "其他出库单"),
    /**
     * 其他入库单
     **/
    QTRK("QTRK", "其他入库单"),

    /**
     * 调拨单
     **/
    DB("DB", "调拨单"),

    TP("TP", "PCP发起的调拨单"),

    ZTDB("ZTDB", "在途调拨单"),

    /**
     * 锁库单
     **/
    LK("LK", "锁库单"),

    /**
     * 解锁单
     **/
    UK("UK", "解锁单"),

    /**
     * 分货单
     **/
    SPHH("SPHH", "分货单"),

    /**
     * 收货策略设置
     **/
    RST("RST", "收货策略设置"),

    /**
     * 库存调整单
     **/
    KCTZ("KCTZ", "库存调整单"),
    /**
     * 在途库存调整单
     **/
    ZTTZ("ZTTZ", "在途库存调整单"),

    /**
     * 共享策略编码
     */
    GHR("GHR", "共享策略编码"),
    ;

    /**
     * 编码
     **/
    private String code;

    /**
     * 描述
     **/
    private String desc;

    CsDocumentCodePrefixEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsDocumentCodePrefixEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsDocumentCodePrefixEnum.values()).stream().filter(e -> {
            return e.getCode().equals(code);
        }).findAny().orElse(null);
    }
}
