package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 单据类型，主要包含八种：发货通知单、出库通知单、出库结果单、发货结果单
 *                     收货通知单、入库通知单、入库结果单、收货结果单
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 2:44 下午
 */
public enum CsDocumentTypeEnum {

    /** 发货通知单 **/
    DELIVERY_NOTICE_ORDER("delivery_notice_order","发货通知单"),

    /** 出库通知单 **/
    OUT_NOTICE_ORDER("out_notice_order","出库通知单"),

    /** 出库结果单 **/
    OUT_RESULT_ORDER("out_result_order","出库结果单"),

    /** 发货结果单 **/
    DELIVERY_RESULT_ORDER("delivery_result_order","发货结果单"),

    /** 收货通知单 **/
    RECEIVE_NOTICE_ORDER("receive_notice_order","收货通知单"),

    /** 入库通知单 **/
    IN_NOTICE_ORDER("in_notice_order","入库通知单"),

    /** 入库结果单 **/
    IN_RESULT_ORDER("in_result_order","入库结果单"),

    /** 收货结果单 **/
    RECEIVE_RESULT_ORDER("receive_result_order","收货结果单"),

    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsDocumentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<String, CsDocumentTypeEnum> DOCUMENT_TYPE_HASHMAP = new HashMap<>();

    static {
        for (CsDocumentTypeEnum typeEnum : values()) {
            DOCUMENT_TYPE_HASHMAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsDocumentTypeEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsDocumentTypeEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }

    public static CsDocumentTypeEnum getTypeEnumByCode(String code) {
        return DOCUMENT_TYPE_HASHMAP.get(code);
    }
}
