package com.dtyunxi.yundt.cube.center.inventory.enums;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * PCP外部单号类型（中台没有详情）
 *
 * @author wenyi
 * @version 1.0
 * @Date 2022/5/18 10:16
 */
public enum CsExternalNumberTypeEnum {
    PLATFORM_ORDER_NO("platform_order_no", "平台单号", CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode()),
    SALES_RETURN_NO("sales_return_no", "销售退货单号", CsPcpBusinessTypeEnum.ORDER_SALES_REFUND.getCode()),
    EAS_PURCHASE_NO("eas_purchase_no", "EAS采购促销物料单号", CsPcpBusinessTypeEnum.PURCHASE.getCode()),
    EAS_OUTSOURCE_NO("eas_outsource_no", "EAS委外成品入库单号", CsPcpBusinessTypeEnum.OUTSOURCE.getCode()),
    EAS_PRODUCTION_NO("eas_production_no", "EAS生产成品入库单号", CsPcpBusinessTypeEnum.PRODUCTION.getCode()),
    EAS_PURCHASE_REFUND_NO("eas_purchase_refund_no", "EAS采购促销物料退货单号", CsPcpBusinessTypeEnum.PURCHASE_REFUND.getCode()),
    EAS_OUTSOURCE_REFUND_NO("eas_outsource_refund_no", "EAS委外成品退货单号", CsPcpBusinessTypeEnum.OUTSOURCE_REFUND.getCode()),
    EAS_OTHER_OUT_NO("eas_other_out_no", "EAS生产成品红单单号", CsPcpBusinessTypeEnum.OTHER_OUT.getCode()),
    ;

    @ApiModelProperty(name = "code", value = "外部单号类型")
    private String code;

    @ApiModelProperty(name = "desc", value = "外部单号中文描述")
    private String desc;

    @ApiModelProperty(name = "businessType", value = "对应业务单类型")
    private String businessType;

    CsExternalNumberTypeEnum(String code, String desc, String businessType) {
        this.code = code;
        this.desc = desc;
        this.businessType = businessType;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getBusinessType() {
        return businessType;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsExternalNumberTypeEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsExternalNumberTypeEnum.values()).stream().filter(e -> {
            return e.getCode().equals(code);
        }).findAny().orElse(null);
    }

    /**
     * 根据businessType获取
     *
     * @param businessType
     * @return
     */
    public static CsExternalNumberTypeEnum getByBusinessType(String businessType) {
        if (StringUtils.isBlank(businessType)) {
            return null;
        }
        return Arrays.asList(CsExternalNumberTypeEnum.values()).stream().filter(e -> {
            return e.getBusinessType().equals(businessType);
        }).findAny().orElse(null);
    }
}