package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 生成编码策略枚举类
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 3:35 下午
 */
public enum CsGenerateCodeStrategyEnum {

    /**
     * 通用编码，不带任何规则的
     **/
    COMMON("Common", "通用编码"),

    /**
     * 发货通知单
     **/
    DELIVERY_NOTICE_ORDER("DeliveryNoticeOrder", "发货通知单"),

    /**
     * 在途发货通知单
     **/
    IN_TRANSIT_DELIVERY_NOTICE_ORDER("InTransitDeliveryNoticeOrder", "在途发货通知单"),

    /**
     * 出库通知单
     **/
    OUT_NOTICE_ORDER("OutNoticeOrder", "出库通知单"),

    /**
     * 出库结果单
     **/
    OUT_RESULT_ORDER("OutResultOrder", "出库结果单"),

    /**
     * 发货结果单
     **/
    DELIVERY_RESULT_ORDE("DeliveryResultOrde", "发货结果单"),

    /**
     * 在途发货结果单
     **/
    IN_TRANSIT_DELIVERY_RESULT_ORDER("InTransitDeliveryResultOrder", "在途发货结果单"),

    /**
     * 收货通知单
     **/
    RECEIVE_NOTICE_ORDER("ReceiveNoticeOrder", "收货通知单"),

    /**
     * 在途收货通知单
     **/
    IN_TRANSIT_RECEIVE_NOTICE_ORDER("InTransitReceiveNoticeOrder", "在途收货通知单"),

    /**
     * 入库通知单
     **/
    IN_NOTICE_ORDER("InNoticeOrder", "入库通知单"),

    /**
     * 入库结果单
     **/
    IN_RESULT_ORDER("InResultOrder", "入库结果单"),

    /**
     * 收货结果单
     **/
    RECEIVE_RESULT_ORDER("ReceiveResultOrder", "收货结果单"),

    /**
     * 在途收货结果单
     **/
    IN_TRANSIT_RECEIVE_RESULT_ORDER("InTransitReceiveResultOrder", "在途收货结果单"),

    /**
     * 物理仓
     **/
    PHYSICS_WAREHOUSE("PhysicsWarehouse", "物理仓"),

    /**
     * 物理仓
     **/
    LOGIC_WAREHOUSE("LogicWarehouse", "物理仓"),

    /**
     * 虚拟仓
     **/
    VIRTUAL_WAREHOUSE("VirtualWarehouse", "虚拟仓"),

    /**
     * 渠道仓
     **/
    CHANNEL_WAREHOUSE("ChannelWarehouse", "渠道仓"),

    /**
     * 采购订单
     **/
    PURCHASE("purchase", "采购订单"),

    /**
     * 委外订单
     **/
    OUTSOURCE("outsource", "委外订单"),

    /**
     * 采购退货订单
     **/
    PURCHASE_RETREAT("purchaseRetreat", "采购退货订单"),

    /**
     * 委外退货订单
     **/
    OUTSOURCE_RETREAT("outsourceRetreat", "委外退货订单"),

    /**
     * 生产返修退厂单
     */
    PRODUCT_REPAIR("productionRetreat", "生产返修退厂单"),

    /**
     * 生产订单
     **/
    PRODUCTION("production", "生产订单"),

    /**
     * 批次调整单
     **/
    BATCH_ADJUSTMENT_ORDER("BatchAdjustmentOrder", "批次调整单"),
    /**
     * 盘点单
     **/
    TAKE_STOCK_ORDER("TakeStockOrder", "盘点单"),
    /**
     * 待检转合格
     **/
    QUALITY_DETAIL("QualityDetail", "待检转合格"),

    /**
     * 其他出入库单
     **/
    OTHER_STORAGE_ORDER("otherStorageOrder", "其他出入库单"),
    /**
     * 其他出库单
     **/
    OTHER_STORAGE_ORDER_OUT("otherStorageOrderOut", "其他出库单"),
    /**
     * 其他入库单
     **/
    OTHER_STORAGE_ORDER_IN("otherStorageOrderIn", "其他入库单"),

    /**
     * 调拨单单
     **/
    TRANSFER_ORDER("transferOrder", "调拨单"),
    /**
     * Pcp发起的调拨单
     **/
    PCP_TRANSFER_ORDER("pcpTransferOrder", "Pcp发起的调拨单"),

    /**
     * 在途调拨单
     **/
    IN_TRANSIT_TRANSFER_ORDER("inTransitTransferOrder", "在途调拨单"),

    /**
     * 锁库单
     **/
    LOCK_ORDER("lockOrder", "锁库单"),

    /**
     * 解锁单
     **/
    UNLOCK_ORDER("unlockOrder", "解锁单"),

    /**
     * 分货单
     **/
    SHARE_GOODS_ORDER("shareGoodsOrder", "分货单"),

    /**
     * 收货策略编码生成规则类
     **/
    RECEIVE_STRATEGY("receiveStrategy", "收货策略编码生成规则类"),

    /**
     * 库存调整单
     **/
    ADJUSTMENT_INVENTORY_ORDER("adjustmentInventoryOrder", "库存调整单"),
    /**
     * 在途库存调整单
     **/
    IN_TRANSIT_ADJUSTMENT_INVENTORY_ORDER("inTransitAdjustmentInventoryOrder", "在途库存调整单"),

    SHARED_CODE("sharedCode", "共享策略编码规则");

    /**
     * 编码
     **/
    private String code;

    /**
     * 描述
     **/
    private String desc;

    CsGenerateCodeStrategyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsGenerateCodeStrategyEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsGenerateCodeStrategyEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }

}
