package com.dtyunxi.yundt.cube.center.inventory.enums;/**


/**
 * 库存中心异常编码
 * @author guigu
 * @date 2022/6/23
 */

public enum CsInventoryExceptionCode {
    /**
     * 库存异常code
     */
    SHIPPINGCAMPONY_NOT_EXIST("1001", "承运商不存在"),
    REPORT_TEMPLATE_NOT_EXIT("1002", "提报模板不存在"),
    REPORT_DATA_ALREADY_EXIT("1003", "当前渠道提报月份提报数据已存在"),
    REPORT_DATA_DETAIL_IS_NULL("1004", "提报数据商品信息为空"),
    REPORT_TEMPLATE_DETAIL_IS_NULL("1005", "获取的提报模板商品信息为空"),
    REPORT_DATA_NOT_EXIT("1006", "提报数据商品在提报模板中不存在"),
    REPORT_DATA_MONTHDATA_NOT_EXIT("1007", "提报数据商品月份在提报模板中不存在"),
    WAREHOUSE_NOT_EXIST("1008", "仓库不存在"),
    REPETITION_CARGO_CODE("1009", "存在重复货品编码"),
    CARGO_CODE_NOT_EXIST("1010", "货品编码没有查到对应的货品信息"),
    CARGO_NOT_EXIST("1011", "货品不存在"),
    REQUEST_USERID_IS_NULL("1012", "请求用户id为空"),
    REQUEST_USERID_IS_NOT_THE_OWNER("1013", "请求用户不是数据所有人"),
    REPORT_DATA_IS_LOCK("1014", "提报数据状态为锁定不可修改"),
    EDIT_REPORT_DATA_IS_NOT_EXIT("1015", "操作的提报数据不存在"),
    DATE_FORMAT_ERROR("1016", "日期格式有误"),
    REPORT_DATA_IMPORT_FILE_ERROR("1017", "获取提报数据导入文件发生错误"),
    PRASE_IMPORT_FILE_ERROR("1018", "解析导入文件发生错误"),
    SALES_REPORT_IS_NOT_EXIT("1019", "提报数据不存在"),
    REPORT_TEMPLATE_DATE_FORMAT_ERROR("1020", "提报模板日期格式有误"),
    PARAM_CAN_NOT_EMPTY("1021", "参数不能为空"),
    CHANNEL_WAREHOUSE_CHOICE_OF_TWO("1022", "渠道ID和仓库ID不能都为空"),
    CARGO_CODE_NOT_EMPTY("1023", "货品编码不能为空"),
    CARGO_INVENTORY_NOT_EXIST("1024", "货品库存信息不存在"),
    NUM_NOT_CORRECT("1025", "数量不能小于等于0"),
    CHANNEL_WAREHOUSE_NOT_EXIT("1026", "渠道库存不存在"),
    INVENTORY_SHORTAGE("1027", "渠道库存不足"),
    CAN_NOT_GET_ITEM_INVENTORY("1028", "获取不到库存"),
    ADDED_WAREHOUSES_IS_NULL("1029", "添加仓库条数不能为空"),
    CHANNEL_HAS_WAREHOUSE("1030", "该渠道已经绑定对应的仓库"),
    EXISTED_LOGICAL_WAREHOUSE("1031", "已存在逻辑总仓"),
    WAREHOUSE_WARNNING_IS_NULL("1032", "传进来的数据列表为空"),
    WAREHOUSES_TYPE_IS_NULL("1033", "仓库类型不能为空"),
    CARGO_ID_NOT_EMPTY("1034", "货品ID不能为空"),
    CARGO_NOT_ENOUGH("1035", "货品库存不足"),
    CARGO_STORAGE_MODIFY_ERROR("1036", "货品库存变动失败"),
    ORDER_EXISTS("1037", "该变动类型来源单号已存在"),
    PREEMPT_NUM_ERROR("1038", "预占库存扣减后数量异常"),
    CARGO_STORAGE_MODIFY_TYPE_ERROR("1039", "库存变动类型错误"),
    WAREHOUSE_WARNNING_IS_NOT_NULL("1040","库存预警修改不能为空"),
    WAREHOUSE_AND_CARGO_IS_NULL("1041","库存预警修改不能为空"),
    WAREHOUSE_IS_NOT_NULL("1042","库存预警修改不能为空"),
    WAREHOUSE_IS_CODE("1043","仓库编码已经存在"),
    WAREHOUSE_ID_NOT_NULL("1044","仓库id不能为空"),
    LOGISTICS_RULE_NOT_EXIST("1045", "物流规则不存在"),
    LOGISTICS_CONFIGURATION_NOT_EXIST("1046", "物流配置不存在"),
    LOGISTICS_RULE_ID_NOT_NULL("1047", "物流规则id不能为空"),
    LOGISTICS_CONFIGURATION_ID_NOT_NULL("1048", "物流配置id不能为空"),
    ROUTE_ID_NOT_NULL("1049","路由id不能为空"),
    ROUTE_RULE_NOT_EXIST("1050","路由规则不存在"),
    CARGO_STORAGE_ROLL_BACK_ERROR("1051", "无预占记录，不能回滚库存"),
    PREEMPT_CARGO_NOT_ENOUGH("1052", "货品预占数量不足，回滚库存失败"),
    SHIPPINGCAMPONY_IS_EXIST("1053", "承运商已存在"),
    WAREHOUSE_NOT_EXIST_NOT_DELETE("1054","仓库不存在，无法删除"),
    REPORT_TEMPLATE_EXIST("1056","该仓库该月已存在有提报模版"),
    ORDERCYCLE_LOCKNUM_Gt_CYCLE("1057","下单周期加锁定月数不可大于编制月数+1"),
    THRESHOLD_VALUE_NOT_GREATER_THAN_MILLION("1058","阈值不能大于一百万"),
    THRESHOLD_VALUE_NOT_LESS_THAN_ZERO("1059","阈值不能小于于0"),
    THRESHOLD_VALUE_NOT_IS_NULL("1060","阈值不能为空"),
    SEND_MESSAGE_FAIL("1061","消息发送失败"),
    NOT_EXIST_DEMAND_PLAN("1062","没有要货计划"),
    REPORT_IMPORT_FILE_ERROR("1063", "获取分货计划导入文件发生错误"),
    MARK_MONTH_NOT_LT_NOW("1064", "记账时间不能少于当前时间"),
    CARGO_NUM_NOT_ENTIRELY_ALLOT("1065", "货物未完全分配"),
    STORAGE_ORDER_DISTRIBUTED("1066", "该入库单已分货"),
    CHANNEL_NOT_EXIST("1067", "渠道编码没有对应的渠道信息"),
    START_NOT_GR_END("1068", "开始时间不能大于结束时间"),
    TEMPLATE_FORMATION_DATA_NOT_DEL("1069", "提报模版生成的固话数据不能删除"),
    FIXED_DEMAND_IMPORT_HEADER_ERROR("1070", "固化数据导入月份表头应该为:2020-02格式"),
    FIXED_DEMAND_SELECT_LENGTH_GR_TWELVE("1071", "固化数据最大查看长度为12个月"),
    CHANNEL_HAS_RULE("1072", "该渠道已经绑定对应的路由"),
    SHIPPINGCAMPONY_ID_NOT_NULL("1073", "承运商id不能为空"),
    SHIPPINGCAMPONY_CODE_NOT_NULL("1074", "承运商code不能为空"),
    LOGISTICS_RULE_SECTION_NOT_REPETITION("1075", "物流规则不能重复"),
    END_DATE_LT_NOW_DATW("1076", "结束月份必须小于当前所在月份"),
    TEMPLATE_ALREADY_EXIST ("1078","模板已存在"),
    NOT_ADJUST_ITEM_NUM ("1079","没有调整差异的商品"),
    TEMPLATE_ITEM_CODE_IS_NOT("1080","导入的商品编码在提报模板中不存在"),
    REPORT_TEMPLATE_ITEM_NOT_EXIT("1081","提报模板不存在该商品"),
    STORAGE_ORDER_ITEM_NOT_EXIT("1082","入库单不存在该商品"),
    REPORT_MONTH_DISTRIBUTE("1083","当月分货了不能编辑这个月的提报模板和销售预测模版"),
    NOT_EXIST_SHOP_ENQUIRY("1084","门店要货申请单不存在"),
    CANCEL_STATUS_ERROR("1085","非待审核状态不能取消"),
    SEPARATE_BIL_STATUS_ERROR("1086","非待审核状态不能进行拆单"),
    SEPARATE_AUDIT_STATUS_ERROR("1087","非待审核或者部分审核状态不能进行审核"),
    SALE_REPORT_MONTH_IS_EMPTY("1088","销售预测提报数据月份数量带[*],必须要有值"),
    REPORT_IMPORT_WAREHOUSE_WARNING_TYPE("1089","导入仓库类型错误"),
    WAHREHOUSE_CODE_CAN_NOT_EMPTY("1090","仓库编码不能为空"),
    IMPORT_TEMPLATE_ERROR("1091","导出模板错误！"),
    IN_WAREHOUSE_NOT_EXIST("1092", "收货仓库不存在"),
    OUT_WAREHOUSE_NOT_EXIST("1093", "发货仓库不存在"),
    DISTRIBUTION_STATUS_ERROR("1094", "非待配货状态不能进行配货"),
    DISTRIBUTION_FAIL_FOR_SOURCE("1095", "配货不成功，门店寻源配货失败"),
    DISTRIBUTION_FAIL_FOR_TRANSFER("1095", "配货不成功，调拨申请失败"),
    CONFIRM_NUM_ERROR("1096", "确认数量不能大于要货数量或可用数量，审核失败"),
    OUT_WAREHOUSE_ANY_NOT_EXIST("1097", "匹配不到任何发货仓库，请确认仓库信息是否初始化"),
    //调拨单
    TRANSFER_ORDER_NOT_EXIST("2001", "调拨单不存在"),
    TRANSFER_ORDER_MODIFY_STATUS_ERROR("2002", "调拨单状态只能为待提交才能修改"),
    TRANSFER_ORDER_AUDIT_STATUS_ERROR("2003", "非待审核状态不能审核"),
    TRANSFER_ORDER_CANCEL_STATUS_ERROR("2004", "非待出库/待审核状态不能取消"),
    TRANSFER_ORDER_FINISH_STATUS_ERROR("2005", "非待入库状态不能手动完成"),
    TRANSFER_ORDER_DETAIL_CANNOT_EMPTY("2006", "数据异常,调拨单明细不能为空"),
    TRANSFER_ORDER_INCORRECT_CLASSIFICATION("2007", "单据类型不正确"),
    TRANSFER_CARGO_CAN_NOT_EMPTY("2008", "请选择需调拨的货品信息"),
    LOGICAL_WAREHOUSE_CAN_NOT_EMPTY("2009", "逻辑总仓不存在或存在多个"),
    GOODS_NOT_EMPTY("2010", "商品不存在"),
    STORAGE_NOT_CORRESPONDING_TRANSFER("2011", "该出入库单没有对应的调拨单"),
    TRANSFER_ORDER_WAIT_STOCK_CLOSE("2012", "只有待入库的调拨单才能手动关闭"),
    IN_NUM_NOT_EQ_OUT_NUM("2013", "出库单数量不等于入库单数量,不能关闭调拨单"),
    ERROR_NOT_HANDLED_CLOSE("2014", "只有异常未处理的调拨单才能手动关闭"),
    LOGICAL_WAREHOUSE_OR_LOGICAL_TOTAL_WAREHOUSE_CAN_NOT_BE_FOUND("2015", "找不到渠道逻辑仓或者逻辑总仓"),
    ERROR_ADJUST_NUM_OVERSTEP("2016", "调整数量不能大于计划数量"),
    ERROR_ADJUST_NUM_NULL("2017", "调整数量不能为空"),
    ERROR_TRANSFER_OVERTAKE_ADJUST_CLOSE("2018", "调拨单存在超发情况,不能关闭"),
    NO_SYSTEM_TYPE_ERROR("2019", "寄售调拨至少一个仓库为寄售仓"),
    RESUBMIT("2019", "单据已存在,请勿重复提交出/入库单"),
    DIRECTIVE_NOT_EXIST("2020", "指令单据不存在"),
    ALREADY_CANCEL("2021", "指令已取消,请勿重新操作"),
    ALREADY_DEAL("2022", "指令已处理完毕,不允许取消"),

    //出入库单
    STORAGE_ORDER_NOT_EXIST("3001", "出/入库单不存在"),
    WAREHOUSE_NOT_EXIST_OR_CODE_ERROR("3002", "仓库不存在或仓库编码错误"),
    SOURCE_CODE_EXIST("3003", "来源编码已经存在"),


    //订单路由
    ROUTING_SUCCEED("0000","路由成功"),
    ROUTING_FAIL("0001","路由失败"),
    CHANNEL_NOT_ROUTING("50001","未找到路由规则"),
    EXISTED_CHANNEL_ROUTING("50001","已存在渠道规则"),
    CHANNEL_WAREHOUSE_STOCK("50002","库存不足"),
    WAREHOUSE_THRESHOLD_VALUE_INSUFFICIENT("50003","仓库阈值不足"),
    PARAMETER_NOT_NULL("50004","参数不能为null"),
    INSTRUCT_DISPOSE_FAIL("50005","推送指令处理失败"),
    ORDER_OUT_ENTER_WAREHOUSE_NOT_NULL("50006","订单出入库类型没找到"),
    CHANNEL_ID_NOT_NULL("50007","来源id不能为空"),
    CHANNEL_NOT_NULL("50014","来源渠道不存在"),
    RULE_CUSTOMIZED_NO_FIND("50008","没有匹配的自定义物流"),
    LOGIC_WAREHOUSE_NOT_EXIST("50009","逻辑仓库不存在"),
    LOGIC_CHANNEL_WAREHOUSE_STOCK("50010","逻辑仓库存不足"),
    THRESHOLD_VALUE_NOT_NULL("50011","发货阈值或实时阈值不能为空"),
    OUT_STORAGE_ORDER_CHANNEL_NOT_EXIST("50012","出库指令渠道找不到"),
    NOT_WAREHOUSE_MISMATCH_CONDITION("50013","没有仓库符合条件"),
    // 发送mq异常
    MQ_FAILED_SEND("4001", "推送出入库当到订单中心mq发送失败"),
    WAREHOUSE_CODES_FAIL("4002", "仓库编码不正确！"),
    CARGO_STORAGE_EMPTY("4003", "货品库存不存在！"),
    WH_CARGO_STORAGE("4004", "仓库有库存不能停用！"),
    WH_STATUS_BANNED("4005", "仓库停用不可导入数据！"),

    AUDIT_REMARK_NOT_NULL("1099", "驳回备注不能为空！"),
    ;

    private final String code;

    private final String msg;

    CsInventoryExceptionCode(String code, String msg) {
        this.code = code;
        this.msg = msg;

    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }

}
