package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 库存操作日志流水类型枚举-
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 2:44 下午
 */
public enum CsInventoryOperateLogTypeEnum {

    /** 总库存 **/
    BALANCE("balance","总库存"),

    /** 预占库存 **/
    PREEMPT("preempt","预占库存"),

    /** 已分配库存 **/
    ALLOCATE("allocate","已分配库存"),

    /** 活动分配库存 **/
    ACTIVITY_ALLOCATE("activityAllocate","活动分配库存"),

    /** 在途库存 **/
    INTRANSIT("intransit","在途库存"),

    /** 已调拨库存 **/
    TRANSFER("transfer","已调拨库存"),

    /** 已完成库存 **/
    COMPLETED("completed","已完成库存"),

    /** 待收库存 **/
    FUTURE_IN("future_in","待收库存"),

    /** 可用库存 **/
    AVAILABLE("available","可用库存"),

    /** 锁定库存 **/
    LOCK_INVENTORY("lock_inventory","锁定库存"),

    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsInventoryOperateLogTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsInventoryOperateLogTypeEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsInventoryOperateLogTypeEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
