package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 仓库属性字段
 *
 * @author chujian
 * @version 1.0
 * @Date 2022/3/8 14:38 下午
 */
public enum CsInventoryPropertyEnum {

    /**
     * 产成品
     **/
    ARTICLES("articles", "产成品"),
    ;

    private String code;

    private String desc;

    CsInventoryPropertyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsInventoryPropertyEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsInventoryPropertyEnum.values()).stream().filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }
}
