package com.dtyunxi.yundt.cube.center.inventory.enums;

/**
 * 库存释放响应结果枚举
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsInventoryReleaseResultEnum {

    /**
     * 有预占记录，且正常释放
     **/
    SUCCESS("SUCCESS", "有预占记录，且正常释放"),
    /**
     * 有预占记录，但释放失败
     **/
    FAIL("FAIL", "有预占记录，但释放失败"),
    /**
     * 没有预占记录，不需要释放
     **/
    UNKNOW("UNKNOW", "没有预占记录，不需要释放")
    ;

    private String code;

    private String desc;

    CsInventoryReleaseResultEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
