package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * @author jingran
 * @version 1.0
 * @Date 2022/6/15 2:58 下午
 */
public enum CsInventorySharedTypeEnum {

    /**
     * 按比例配置
     **/
    RATIO("ratio", "按比例配置"),

    /**
     * 按数量配置
     **/
    QUANTITY("quantity", "按数量配置"),

    ;
    private String code;

    private String desc;

    CsInventorySharedTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsInventoryStrategyEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsInventoryStrategyEnum.values()).stream().filter(eo -> code.equals(eo.getCode())).findAny().orElse(null);
    }

}
