package com.dtyunxi.yundt.cube.center.inventory.enums;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 库存操作来源类型
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/12 3:25 下午
 */
public enum CsInventorySourceTypeEnum {
    //出库
    /** 销售出库 **/
    OUT_SALE("out_sale","101","销售出库"),
    /** 下单预占 **/
    OUT_SALE_PREEMPT("out_sale_preempt", "108", "下单预占", CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode()),
    /** 分销出库 **/
    OUT_SEPARATE("out_separate","102","分销出库"),
    OUT_SEPARATE_PREEMPT("out_separate_preempt","1020","分销出库预占"),
    /** 退换货出库 **/
    OUT_BACKTRACK("out_backtrack","103","退换货出库"),
    OUT_BACKTRACK_PREEMPT("out_backtrack_preempt","1030","退换货出库预占"),
    /** 一级退换货出库 **/
    OUT_TOP_BACKTRACK("out_top_backtrack","104","一级退换货出库"),
    OUT_TOP_BACKTRACK_PREEMPT("out_top_backtrack_preempt","1040","一级退换货出库预占"),
    /** 二级退换货出库 **/
    SECOND_OUT_TOP_BACKTRACK("second_out_top_backtrack","110","二级退换货出库"),
    SECOND_OUT_TOP_BACKTRACK_PREEMPT("second_out_top_backtrack_preempt","1100","二级退换货出库预占"),
    /** 调拨出库 **/
    OUT_ALLOT("out_allot","105","调拨出库"),
    /** 调拨出库预占 **/
    OUT_ALLOT_PREEMPT("out_allot_preempt","1050","调拨出库预占"),
    /** 其他出库 **/
    OUT_OTHER("out_other","106","其他出库",CsPcpBusinessTypeEnum.OTHER_OUT.getCode()),
    /** 其他出库预占 **/
    OUT_OTHER_PREEMPT("out_other_preempt","0211","其他出库预占", CsPcpBusinessTypeEnum.OTHER_OUT.getCode()),
    OUT_OTHER_RELEASE("out_other_release","0212","其他出库释放"),
    /** 物料调整出库 **/
    OUT_MATERIAL_ADJUST("out_material_adjust","107","物料调整出库"),
    OUT_MATERIAL_ADJUST_PREEMPT("out_material_adjust_preempt","1070","物料调整出库预占"),
    /** 报废出库 **/
    SCRAP_OUT("out_scrap","109","报废出库"),
    /** 活动下单预占 **/
    OUT_ACT_ORDER_PREEMPT("out_act_order_preempt", "302", "活动下单预占", CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode()),
    /** 活动发货扣减 **/
    OUT_ACT_DELIVER_DEDUCTION("out_act_deliver_deduction","306","活动发货扣减"),
    /** 活动审批预占 **/
    OUT_ACT_AUDIT_PREEMPT("out_act_audit_preempt", "307", "活动审批预占", CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode()),
    /** 业务审批预占 **/
    OUT_BUSINESS_APPROVE_PREEMPT("out_business_approve_preempt", "401", "业务审批预占", CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode()),
    /** 财务审批预占 **/
    OUT_FINANCE_APPROVE_PREEMPT("out_finance_approve_preempt", "402", "财务审批预占", CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode()),
    /** 内部调整出库 **/
    OUT_INTERIOR_ADJUST("out_interior_adjust","502","内部调整出库"),
    OUT_INTERIOR_ADJUST_PREEMPT("out_interior_adjust_preempt","5020","内部调整出库预占"),
    /** 调整单（出库）减少 **/
    OUT_TO_ADJUST("out_to_adjust","601","调整单（出库）减少"),
    /** 批次调整单预占 **/
    BATCH_ADJUSTMENT_SUBMITTED_PREEMPT("batch_adjustment_submitted_preempt", "701", "批次调整单预占", CsPcpBusinessTypeEnum.BATCH_ADJUST.getCode()),

    /** 库存调整单预占*/
    INVENTORY_ADJUSTMENT_SUBMITTED_PREEMPT("inventory_adjustment_submitted_preempt", "801", "库存调整单预占", CsPcpBusinessTypeEnum.INVENTORY_ADJUST.getCode()),

    //入库
    /** 采购入库 **/
    IN_PURCHASE("in_purchase","201","采购入库"),
    /** 分销入库 **/
    IN_SEPARATE("in_separate","202","分销入库"),
    /** 退换货入库 **/
    IN_BACKTRACK("in_backtrack","203","退换货入库"),
    /** 下级退换货入库 **/
    IN_DOWN_BACKTRACK("in_down_backtrack","204","下级退换货入库"),
    /** 调拨入库 **/
    IN_ALLOT("in_allot","205","调拨入库"),
    /** 调拨入库 **/
    IN_OTHER("in_other","206","其他入库",CsPcpBusinessTypeEnum.OTHER_IN.getCode()),
    /** 物料调整入库 **/
    IN_MATERIAL_ADJUST("in_material_adjust","207","物料调整入库"),
    /** 释放下单的预占 **/
    IN_SALE_RELEASE("in_sale_release","209","订单取消释放"),

    /** 二级采购入库 **/
    SECOND_IN_PURCHASE("second_in_purchase","210","二级采购入库"),
    /** 业务审批释放 **/
    IN_BUSINESS_APPROVE_RELEASE("in_business_approve_release","501","业务审批释放"),
    /** 财务审批释放 **/
    IN_FINANCE_APPROVE_RELEASE("in_finance_approve_release","502","财务审批释放"),
    /** 订单捕获异常释放 **/
    IN_ORDER_CATCH_RELEASE("in_order_catch_release","601","单据捕获异常释放"),
    /** 活动取消预占 **/
    IN_ACT_CANCEL_PREEMPT("in_act_cancel_preempt","303","活动取消预占"),
    /** 活动结束归还 **/
    IN_ACT_FINISH_BACKTRACK("in_act_finish_backtrack","304","活动结束归还"),
    /** 活动审批释放 **/
    IN_ACT_AUDIT_RELEASE("in_act_audit_release","305","活动审批释放"),
    /** 批次调整单释放 **/
    BATCH_ADJUSTMENT_RELEASE("batch_adjustment_release", "306", "批次调整单释放"),
    /**
     * 库存调整单预占释放
     */
    INVENTORY_ADJUSTMENT_SUBMITTED_PREEMPT_RELEASE("inventory_adjustment_submitted_preempt_release", "801", "库存调整单预占释放", CsPcpBusinessTypeEnum.INVENTORY_ADJUST.getCode()),


    /** 库存初始化 **/
    INITIALIZE_INVENTORY("initialize_inventory","208","库存初始化/盘点"),
    /** 盘点入库 **/
    CHECK_INVENTORY("check_inventory","666","盘点入库"),
    /** 调整单（入库）增加 **/
    IN_TO_ADJUST("in_to_adjust","602","调整单（入库）增加"),
//    --------------------------PCP枚举------------------------------------
    /** 销售出库预占 **/
    PCP_OUT_SALE_PREEMPT("pcp_out_sale_preempt","308","销售出库预占"),
    /** 销售出库预占 **/
    PCP_OUT_SALE_RELEASE("pcp_out_sale_release","308","销售出库释放"),
    /** 销售出库 **/
    PCP_OUT_SALE_REFUND("out_sale_refund","308","销售退入库"),
    /** 采购入库 **/
    PURCHASE("purchase","-","采购入库"),
    /** 委外订单 **/
    OUTSOURCE("outsource","-","委外订单"),
    /** 采购退货 **/
    PURCHASE_RETREAT("purchase_refund","-","采购退货"),
    /** 采购退货预占 **/
    PURCHASE_RETREAT_PREEMPT("purchase_refund_preempt", "-", "采购退货预占", CsPcpBusinessTypeEnum.PURCHASE_REFUND.getCode()),
    /** 采购退货预占释放 **/
    PURCHASE_RETREAT_PREEMPT_RELEASE("purchase_refund_preempt_release","-","采购退货预占释放"),
    /** 委外退货 **/
    OUTSOURCE_RETREAT("outsource_refund","-","委外退货"),
    /** 委外退货预占 **/
    OUTSOURCE_RETREAT_PREEMPT("outsource_refund_preempt", "-", "委外退货预占", CsPcpBusinessTypeEnum.OUTSOURCE_REFUND.getCode()),
    /** 委外退货预占释放 **/
    OUTSOURCE_RETREAT_PREEMPT_RELEASE("outsource_refund_preempt_release","-","委外退货预占释放"),
    /** 生产订单 **/
    PRODUCTION("production","-","生产订单"),
    /** 采购入库取消 **/
    PURCHASE_CANCEL("purchase_cancel","-","采购取消"),
    /** 采购退货取消 **/
    PURCHASE_RETREAT_CANCEL("purchase_retreat_cancel","-","采购退货取消"),
    /** 盘盈 **/
    SURPLUS("surplus","-","盘盈"),
    /** 盘亏 **/
    DISH("dish","-","盘亏"),
    /** 盘亏预占 **/
    DISH_PREEMPT("dish_preempt", "-", "盘亏预占", CsPcpBusinessTypeEnum.CHECK_STOCK.getCode()),
    /** 盘亏预占释放 **/
    DISH_PREEMPT_RELEASE("dish_preempt_release","-","盘亏预占释放"),
    /** 调拨入库 **/
    TRANSFER_OTHER("transfer_order","2310","调拨单"),
    TRANSFER_OTHER_PREEMPT("out_allot_preempt","2311","调拨单预占", CsPcpBusinessTypeEnum.ALLOT_OUT.getCode()),
    TRANSFER_OTHER_RELEASE("out_allot_release","2312","调拨单释放"),

    LOCK_INVENTORY("lock_inventory", "-", "锁库单锁库"),
    UNLOCK_INVENTORY("unlock_inventory", "-", "锁库单解锁"),
    //冗余过来，避免底层报错
    INTERNAL_DEAL("internal_deal", "","调拨单（内部交易）"),
    /**
     * 订单销售退
     **/
    ORDER_SALES_REFUND("order_sales_refund", "","订单销售出退"),
    /**
     * 营养家积分
     */
    NUTRITION_INTEGRAL("nutrition_integral","", "营养家积分"),
    /**
     * 调拨单（普通调拨）
     **/
    ALLOT_OUT("allot_out","", "库存调拨单"),

    ALLOT_SALE("allot_sale","", "销售调拨单"),

    ALLOT_SALE_BH("allot_sale_bh","", "销售补货调拨单"),

    /**
     * 调拨单（调拨出跨物理仓）/调拨单（调拨出不跨物理仓）
     **/
    ALLOT_OUT_ONLY("allot_out_only","", "库存调拨单（调拨出库）"),

    /**
     * 调拨单（调拨入库）
     **/
    ALLOT_IN_ONLY("allot_in_only", "","库存调拨单（调拨入库）"),

    /**
     * 调拨单（仅记录）
     **/
    ALLOT_ONLY_RECORD("allot_only_record", "","库存调拨单（仅记录）"),
    /**
     * 内部交易退
     **/
    INTERNAL_DEAL_RETURN("internal_deal_return", "","内部交易退"),
    /**
     * 销售退转内部交易
     **/
    SALE_RETURN_INTERNAL_DEAL("sale_return_internal_deal","", "销售退转内部交易"),
    CLAIM_REISSUE("claim_reissue", "", "仓库索赔补发"),
    CLAIM_POSTING("claim_posting", "", "仓库索赔过账"),
    CHILD_DIRECT_SALES("child_direct_sales", "", "子公司直销"),
    PRESALE_ORDER("presale_order", "", "预售订单"),
    /**
     * 生产返修退厂单
     */
    PRODUCT_REPAIR("product_repair", "","生产返修退厂单");



    private String code;

    private String value;

    private String desc;

    @ApiModelProperty(name = "businessType",value = "业务类型 com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum")
    private String businessType;

    CsInventorySourceTypeEnum(String code, String value, String desc) {
        this.code = code;
        this.value = value;
        this.desc = desc;
    }

    CsInventorySourceTypeEnum(String code, String value, String desc, String businessType) {
        this.code = code;
        this.value = value;
        this.desc = desc;
        this.businessType = businessType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getBusinessType() {
        return businessType;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsInventorySourceTypeEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.stream(CsInventorySourceTypeEnum.values()).filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }

    /**
     * 根据类型参数获取枚举
     *
     * @param value
     * @return
     */
    public static CsInventorySourceTypeEnum getByValue(String value){
        if(StringUtils.isBlank(value)){
            return null;
        }
        return Arrays.stream(CsInventorySourceTypeEnum.values()).filter(eo->value.equals(eo.getValue())).findAny().orElse(null);
    }

    /**
     * 根据业务类型参数获取枚举
     *
     * @param businessType
     * @return
     */
    public static CsInventorySourceTypeEnum getByBusinessType(String businessType) {
        if (StringUtils.isBlank(businessType)) {
            return null;
        }
        return Arrays.asList(CsInventorySourceTypeEnum.values()).stream().filter(eo -> businessType.equals(eo.getBusinessType())).findAny().orElse(null);
    }
}
