package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 库存策略枚举
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/12 1:44 下午
 */
public enum CsInventoryStrategyEnum {

    /** 普通策略 **/
    COMMON("common","普通库存策略"),

    /** 物理仓库存 **/
    PHYSICS("physics","物理仓库存"),

    /** 逻辑仓库存 **/
    LOGIC("logic","逻辑仓库存"),

    /** 虚拟仓库存 **/
    VIRTUAL("virtual","虚拟仓库存"),

    /** 渠道仓库存 **/
    CHANNEL("channel","渠道仓库存"),

    /** 活动库存 **/
    ACTIVITY("activity","活动库存"),

    ;
    private String code;

    private String desc;

    CsInventoryStrategyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsInventoryStrategyEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsInventoryStrategyEnum.values()).stream().filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }
}
