package com.dtyunxi.yundt.cube.center.inventory.enums;

public enum CsItemDrugEnum {
    ITEM_DRUG_DUST(100, "粉剂"),
    ITEM_DRUG_OINTMENET(101, "膏剂"),
    ITEM_DRUG_CHEWING(103, "咀嚼片"),
    ITEM_DRUG_TROCHE(104, "片剂"),
    ITEM_DRUG_SOFT_CAPSULE(105, "软胶囊"),
    ITEM_DRUG_LATIN_CAPSULE(106, "硬胶囊"),
    ITEM_DRUG_AQUA(107, "水剂"),
    ITEM_DRUG_SYR(108, "糖浆剂"),
    ITEM_DRUG_HONEY(109, "蜂蜜"),
    ITEM_DRUG_JELLY(110, "软糖"),
    ITEM_DRUG_THER(111, "其他"),

    ;

    CsItemDrugEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;
    private String desc;


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(Integer code) {
        for (CsItemDrugEnum value : CsItemDrugEnum.values()) {
            if (value.code ==code) {
                return value.desc;
            }
        }
        return null;
    }

    public static CsItemDrugEnum getStatusByCode(Integer code) {
        for (CsItemDrugEnum value : CsItemDrugEnum.values()) {
            if (value.code == code) {
                return value;
            }
        }
        return null;
    }
}
