package com.dtyunxi.yundt.cube.center.inventory.enums;

public enum CsItemUnitEnum {
    UNIT_GE("1001", "个"),
    UNIT_JIAN("1002", "件"),
    UNIT_PING("1003", "瓶"),
    UNIT_GUAN("1004", "罐"),
    UNIT_TONG("1005", "桶"),
    UNIT_HE("1006", "盒"),
    UNIT_TAO("1007", "套"),
    UNIT_BEN("1008", "本"),
    UNIT_TAI("1009", "台"),
    UNIT_FU("1010", "副"),
    UNIT_ZHANG("1011", "张"),
    UNIT_DAI("1012", "袋"),
    UNIT_FEN("1013", "份"),
    UNIT_BA("1014", "把"),
    UNIT_ZHI("1015", "支"),
    UNIT_TIAO("1016", "条"),
    UNIT_DUI("1017", "对"),
    UNIT_BAO("1018", "包"),
    UNIT_SHUANG("1019", "双"),
    UNIT_XIANG("1020", "箱"),
    ;

    CsItemUnitEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;
    private String desc;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (CsItemUnitEnum value : CsItemUnitEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }

    public static CsItemUnitEnum getStatusByCode(String code) {
        for (CsItemUnitEnum value : CsItemUnitEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}
