package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 锁库单记录状态
 *
 * @author wenyi
 * @version 1.0
 * @Date 2022/6/9 5:38 下午
 */
public enum CsLockLogStatusEnum {

    /**
     * 正常
     **/
    NORMAL("normal", "正常"),

    /**
     * 异常
     **/
    ABNORMAL("abnormal", "异常"),

    ;

    private String code;

    private String desc;

    CsLockLogStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsLockLogStatusEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsLockLogStatusEnum.values()).stream()
                .filter(e -> e.getCode().equals(code)).findAny().orElse(null);
    }
}
