package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 锁库单记录类型
 *
 * @author wenyi
 * @version 1.0
 * @Date 2022/5/30 5:38 下午
 */
public enum CsLockTypeEnum {

    /**
     * 锁库
     **/
    LOCK("lock", "锁库"),

    /**
     * 解锁
     **/
    UNLOCK("unlock", "解锁"),

    ;

    private String code;

    private String desc;

    CsLockTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsLockTypeEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsLockTypeEnum.values()).stream()
                .filter(e -> e.getCode().equals(code)).findAny().orElse(null);
    }
}
