package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 逻辑仓仓库线上/线下标识     线上-on_line   线下-off_line
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 2:56 下午
 */
public enum CsLogicWarehouseOnLineEnum {
    /** 初始 **/
    ON_LINE("on_line","线上"),

    /** 线下 **/
    OFF_LINE("off_line","线下"),
    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsLogicWarehouseOnLineEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsLogicWarehouseOnLineEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsLogicWarehouseOnLineEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
