package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 逻辑仓仓库属性,产成品、半成品、专柜、第三方、产成品/促销物料、促销物料
 * 产成品-finished_product   半成品-semi_finished_product   专柜-shoppe    第三方-third_party   促销物料-promotionp_boring
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 2:56 下午
 */
public enum CsLogicWarehousePropertyEnum {
    /** 产成品 **/
    FINISHED_PRODUCT("finished_product","产成品"),

    /** 半成品 **/
    SEMI_FINISHED_PRODUCT("semi_finished_product","半成品"),

    /** 专柜 **/
    SHOPPE("shoppe","专柜"),

    /** 第三方 **/
    THIRD_PARTY("third_party","第三方"),

    /** 促销物料 **/
    PROMOTIONP_BORING("promotionp_boring","促销物料"),
    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsLogicWarehousePropertyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsLogicWarehousePropertyEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsLogicWarehousePropertyEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
