package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 逻辑仓仓库品质：待检、不合格、合格、待处理（质检不合格的产品，做其他处理）、其他
 * 待检-wait_inspection   不合格-un_qualified   合格-qualified    待处理-pending  其他-other
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 2:56 下午
 */
public enum CsLogicWarehouseQualityEnum {
    /** 待检 **/
    WAIT_INSPECTION("wait_inspection","待检"),

    /** 不合格 **/
    UN_QUALIFIED("un_qualified","不合格"),

    /** 合格 **/
    QUALIFIED("qualified","合格"),

    /** 待处理 **/
    PENDING("pending","待处理"),

    /** 其他 **/
    OTHER("other","其他"),

    /** 报废 **/
    SCRAP("scrap","报废")
    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsLogicWarehouseQualityEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsLogicWarehouseQualityEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsLogicWarehouseQualityEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
