package com.dtyunxi.yundt.cube.center.inventory.enums;

public enum CsOrderStatusEnum {
    INIT("1010", "草稿"),
    DELIVERY_WAIT_AUDIT("1011", "待审核"),
    DELIVERY_OUT("1012", "出库"),
    DELIVERY_OUT_ING("1013", "出库中"),
    DELIVERY_OUT_FINISH("1014", "已完成"),
    DELIVERY_CANCEL("1015", "已取消"),

    RECEIVE_WAIT_AUDIT("2011", "待审核"),
    RECEIVE_WAIT_DELIVER("2012", "待配发"),
    RECEIVE_DELIVERED("2013", "已配发"),
    RECEIVE_WAIT_RECEIVE("2014", "待收货"),
    RECEIVE_FINISH("2015", "已完成"),
    RECEIVE_CANCEL("2016", "已取消"),
    RECEIVE_ING("2017", "入库中"),

    ADJUST_WAIT_AUDIT("3011", "待审核"),
    ADJUST_FINISH("3012", "已调整"),
    ADJUST_REFUSE("3013", "审批拒绝"),
    WAIT_DELIVERY("1016", "待发货"),

    //==================以下是针对PCP V2.0的各种单据的枚举定义========================
    /** ====发货通知单状态==== **/
    /** 待发货 **/
    DNO_WAIT_DELIVERY("dno_wait_delivery","待发货"),
    /** 待发货 **/
    DNO_PORTION_DELIVERY("dno_portion_delivery","部分发货"),
    /** 全部发货 **/
    DNO_TOTAL_DELIVERY("dno_total_delivery","全部发货"),
    /** 已取消 **/
    DNO_CANCEL("dno_cancel","已取消"),
    /** 已挂起 **/
    DNO_HANG_UP("dno_hang_up","已挂起"),


    /** ====发货结果单状态==== **/
    /** 已发货 **/
    DRO_DELIVERED("dro_delivered","已发货"),
    /** 待发货 **/
    DRO_ERROR("dro_error","异常"),
    /** 挂起 **/
    DRO_HANG_UP("dro_hang_up","挂起"),

    /** ====收货通知单状态==== **/
    /** 待收货 **/
    RNO_WAIT_RECEIVE("rno_wait_receive","待收货"),
    /** 部分收货 **/
    RNO_PORTION_RECEIVE("rno_portion_receive","部分收货"),
    /** 全部收货 **/
    RNO_TOTAL_RECEIVE("rno_total_receive","全部收货"),
    /** 已取消 **/
    RNO_CANCEL("rno_cancel","已取消"),
    /** 已挂起 **/
    RNO_HANG_UP("rno_hang_up","已挂起"),

    /** ====收货结果单状态==== **/
    /** 已收货 **/
    RRO_RECEIVED("rro_received","已收货"),
    /** 异常 **/
    RRO_ERROR("rro_error","异常"),
    /** 挂起 **/
    RRO_HANG_UP("rro_hang_up","挂起"),

    /** ====出库通知单状态==== **/
    /** 待出库 **/
    ONO_WAIT_OUT("ono_wait_out","待出库"),
    /** 部分出库 **/
    ONO_PORTION_OUT("ono_portion_out","部分出库"),
    /** 全部出库 **/
    ONO_TOTAL_OUT("ono_total_out","全部出库"),
    /** 取消 **/
    ONO_CANCEL("ono_cancel","取消"),

    /** ====出库结果单状态==== **/
    /** 已出库 **/
    ORO_DONE_OUT("oro_done_out","已出库"),
    /** 异常 **/
    ORO_ERROR("oro_error","异常"),
    /** 挂起 **/
    ORO_HANG_UP("oro_hang_up","挂起"),

    /** ====入库通知单状态==== **/
    /** 待入库 **/
    INO_WAIT_IN("ino_wait_in","待入库"),
    /** 部分入库 **/
    INO_PORTION_IN("ino_portion_in","部分入库"),
    /** 全部入库 **/
    INO_TOTAL_IN("ino_total_in","全部入库"),
    /** 取消 **/
    INO_CANCEL("ino_cancel","取消"),

    /** ====入库结果单状态==== **/
    /** 已入库 **/
    IRO_DONE_IN("iro_done_in","已入库"),
    /** 异常 **/
    IRO_ERROR("iro_error","异常"),
    /** 挂起 **/
    IRO_HANG_UP("iro_hang_up","挂起"),

    ;

    CsOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;
    private String desc;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (CsOrderStatusEnum value : CsOrderStatusEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }

    public static CsOrderStatusEnum getStatusByCode(String code) {
        for (CsOrderStatusEnum value : CsOrderStatusEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}
