/**
 * @(#) AdjustActionEnum.java 1.0 2021/11/1/001
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.enums;

/**
 * 其他出库单状态枚举
 *
 * @author wuyue
 * @date 2022/04/26
 * @since 1.0.0
 */
public class CsOtherStorageOrderStatusEnum {

    public enum OUT {

        /**
         * 待提交
         */
        WAIT_COMMIT("wait_commit", "待提交"),
        /**
         * 待一级审核
         */
        WAIT_LEVEL_ONE_AUDIT("wait_level_one_audit", "待一级审核"),
        /**
         * 待二级审核
         */
        WAIT_LEVEL_TWO_AUDIT("wait_level_two_audit", "待二级审核"),
        /**
         * 待出库
         */
        WAIT_OUT("wait_out", "待出库"),
        /**
         * 部分出库
         */
        PORTION_OUT("portion_out", "部分出库"),
        /**
         * 已完成
         */
        FINISH("finish", "已完成"),
        /**
         * 已取消
         **/
        CANCEL("cancel", "已取消"),
        /**
         * 已关闭
         */
        CLOSED("closed", "已关闭"),
        /**
         * 审核不通过
         */
        AUDIT_FAILED("audit_failed", "审核不通过"),
        /**
         * 待生成出库通知单
         */
        WAIT_GENERATE_OUT_NOTICE_ORDER("wait_generate_out_notice_order", "待生成出库通知单"),
        /**
         * 待生成发货结果单
         */
        WAIT_GENERATE_OUT_RESULT_ORDER("wait_generate_out_result_order", "待生成发货结果单"),
        /**
         * 挂起
         */
        HANG_UP("hang_up", "挂起");

        private String code;
        private String desc;

        OUT(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public enum IN {

        /**
         * 待提交
         */
        WAIT_COMMIT("wait_commit", "待提交"),
        /**
         * 待审核
         */
        WAIT_AUDIT("wait_audit", "待审核"),
        /**
         * 待入库
         */
        WAIT_IN("wait_in", "待入库"),
        /**
         * 已完成
         */
        FINISH("finish", "已完成"),
        /**
         * 审核不通过
         */
        AUDIT_FAILED("audit_failed", "审核不通过"),
        /**
         * 部分入库
         */
        PORTION_IN("portion_in", "部分入库"),
        /**
         * 待生成入库通知单
         */
        WAIT_GENERATE_IN_NOTICE_ORDER("wait_generate_in_notice_order", "待生成入库通知单"),
        /**
         * 待生成收货结果单
         */
        WAIT_GENERATE_IN_RESULT_ORDER("wait_generate_in_result_order", "待生成收货结果单"),
        /**
         * 挂起
         */
        HANG_UP("hang_up", "挂起");

        private String code;
        private String desc;

        IN(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


}
