package com.dtyunxi.yundt.cube.center.inventory.enums;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * PCP业务类型
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsPcpBusinessTypeEnum {

    /**
     * 订单销售出库
     **/
    ORDER_SALES_OUT("order_sales_out", "订单销售出库"),
    /**
     * 订单销售退
     **/
    ORDER_SALES_REFUND("order_sales_refund", "订单销售出退"),
    /**
     * 营养家积分
     */
    NUTRITION_INTEGRAL("nutrition_integral", "营养家积分"),

    /**
     * 预售订单
     */
    PRESALE_ORDER("presale_order", "预售订单"),

    /**
     * 仓库索赔补发
     */
    CLAIM_REISSUE("claim_reissue", "仓库索赔补发"),
    /**
     * 仓库索赔过账
     */
    CLAIM_POSTING("claim_posting", "仓库索赔过账"),
    /**
     * 调拨单（普通调拨-跨物理仓）
     **/
    ALLOT_OUT("allot_out", "库存调拨单"),

    ALLOT_LOGIC_OUT("allot_logic_out", "逻辑调拨"),
    /**
     * 调拨单（调拨出跨物理仓）/调拨单（调拨出不跨物理仓）
     **/
    ALLOT_OUT_ONLY("allot_out_only", "库存调拨单（调拨出库）"),

    /**
     * 调拨单（调拨入库）
     **/
    ALLOT_IN_ONLY("allot_in_only", "库存调拨单（调拨入库）"),

    /**
     * CC调拨
     */
    CC_ALLOT("cc_allot","CC调拨"),
    /**
     * BC调拨
     */
    BC_ALLOT("bc_allot","BC调拨"),
    /**
     * CB调拨
     */
    CB_ALLOT("cb_allot","CB调拨"),

    /**
     * 调拨单（仅记录）
     **/
    ALLOT_ONLY_RECORD("allot_only_record", "库存调拨单（仅记录）"),
    /**
     * 内部交易退
     **/
    INTERNAL_DEAL_RETURN("internal_deal_return", "内部交易退"),
    /**
     * 销售退转内部交易
     **/
    SALE_RETURN_INTERNAL_DEAL("sale_return_internal_deal", "销售退转内部交易"),

    /**
     * 调拨单（内部交易）
     * TCBJ: INTERNAL_DEAL("internal_deal", "多方调拨单"),
     **/
    INTERNAL_DEAL("internal_deal", "调拨单（内部交易）"),
    /**
     * 调拨单（待检转合格）
     **/
    INSPECTION_QUALIFIED("inspection_qualified", "调拨单（待检转合格）"),
    /**
     * 采购促销物料入库
     **/
    PURCHASE("purchase", "采购促销物料入库"),
    /**
     * 委外成品入库
     **/
    OUTSOURCE("outsource", "委外成品入库"),
    /**
     * 生产成品入库
     **/
    PRODUCTION("production", "生产成品入库"),
    /**
     * 采购订单退货
     **/
    PURCHASE_REFUND("purchase_refund", "采购订单退货"),
    /**
     * 委外订单退货
     **/
    OUTSOURCE_REFUND("outsource_refund", "委外订单退货"),
    /**
     * 其他入库
     **/
    OTHER_IN("other_in", "其他入库"),
    /**
     * 其他出库
     **/
    OTHER_OUT("other_out", "其他出库"),
    /**
     * 批次号调整
     **/
    BATCH_ADJUST("batch_adjust", "批次号调整"),

    /**
     * 库存调整单
     */
    INVENTORY_ADJUST("inventory_adjust", "库存调整"),
    /**
     * 盘点单
     **/
    CHECK_STOCK("check_stock", "盘点单"),
    /**
     * 平台订单号（中台没有详情信息）改为调用 com.dtyunxi.yundt.cube.center.inventory.enums.CsExternalNumberTypeEnum#PLATFORM_ORDER_NO
     */
    @Deprecated
    PLATFORM_ORDER_NO("platform_order_no", "平台订单号"),
    /**
     * 销售订单-经销订单
     **/
    AGENCY_ORDER("agency_order", "经销订单"),
    /**
     * 销售订单-专柜订单
     **/
    SHOPPE_ORDER("shoppe_order", "专柜订单"),
    /**
     * 销售订单-积分订单
     **/
    INTEGRAL_ORDER("integral_order", "积分订单"),
    /**
     * 销售订单-货补订单
     **/
    REPLENISHMENT_ORDER("replenishment_order", "货补订单"),
    /**
     * 销售订单-活动订单
     **/
    ACTIVITY_ORDER("activity_order", "活动订单"),
    /**
     * 销售订单-消费者退换货
     **/
    CUSTOMER_REFUNDING_ORDER("customer_refunding_order", "消费者退换货"),
    /**
     * 销售订单-索赔订单
     **/
    COMPENSATION_ORDER("compensation_order", "索赔订单"),
    /**
     * 销售订单-质量退换货
     **/
    QUALITY_REFUNDING_ORDER("quality_refunding_order", "质量退换货"),
    /**
     * 销售订单-少货补发
     **/
    REPLENISH_ORDER("replenish_order", "少货补发"),
    /**
     * 销售订单-普通订单
     **/
    COMMON_ORDER("common_order", "普通订单"),
    /**
     * 调拨单（近效期/失效期商品调拨）
     **/
    ALLOT_LOSE_EFFICACY("allot_lose_efficacy", "调拨单（近效期/失效期商品调拨）"),
    /**
     * 调拨单（B-C仓调拨）
     **/
    ALLOT_BC_EFFICACY("allot_bc_efficacy", "调拨单（B-C仓调拨）"),
    /**
     * 锁库单
     */
    LOCK_ORDER("lock_order", "锁库单"),
    /**
     * 分货单
     */
    SHARE_GOODS_ORDER("share_goods_order", "分货单"),


    //-----------------------字典表枚举-----------------------
    /**
     * 仓库调拨（手工创建）
     */
    DICT_ALLOT_WAREHOUSE("71012", "仓库调拨（手工创建）"),
    /**
     * 寄售调拨
     */
    DICT_ALLOT_CONSIGNMENT_SALE("71011", "寄售调拨(手工创建)"),

    /**
     * 门店要货
     */
    DICT_ALLOT_STORE_ENQUIRY("71007", "门店要货"),
    /**
     * 店售仓发
     */
    DICT_ALLOT_WAREHOUSE_DELIVERY("allot_warehouse_delivery", "店售仓发"),
    /**
     * 门店要货退回
     */
    DICT_ALLOT_STORE_ENQUIRY_REFUND("71008", "门店要货退回"),
    /**
     * 门店横调
     */
    DICT_ALLOT_STORE_RAISED("71009", "门店横调"),
    /**
     * 员工借机
     */
    DICT_ALLOT_STAFF_BORROW("71003", "员工借机"),
    /**
     * 员工还机
     */
    DICT_ALLOT_STAFF_RETURN("71004", "员工还机"),
    /**
     * 试产机借用
     */
    DICT_ALLOT_PRODUCTION_BORROW("71001", "试产机借用"),
    /**
     * 试产机归还
     */
    DICT_ALLOT_PRODUCTION_RETURN("71002", "试产机归还"),

    /**
     * 售后单
     */
    AFTER_SALE("after_sale", "售后单"),

    /**
     * 生产返修退厂单
     */
    PRODUCT_REPAIR("product_repair", "生产返修退厂单"),
    /**
     * 在途转合格(调拨单)
     */
    IN_TRANSIT_TRANSFER("in_transit_transfer", "在途转合格"),
    /**
     * 在途库存调整单
     */
    IN_TRANSIT_ADJUSTMENT("in_transit_adjustment", "在途库存调整单"),

    /**
     * 在途库存出库
     */
    IN_TRANSIT_ADJUSTMENT_OUT("in_transit_adjustment_out", "在途库存出库"),
    /**
     * 在途库存入库
     */
    IN_TRANSIT_ADJUSTMENT_IN("in_transit_adjustment_in", "在途库存入库"),

    INTERNAL_DISTRIBUTION("internal_distribution", "内部分销"),
    SECONDARY_DISTRIBUTION("secondary_distribution", "二级分销"),
    OTHER_OUT_STOCK("other_out_stock", "销售-其他出库"),

    ALLOT_SALE("allot_sale", "销售调拨单"),

    ALLOT_SALE_BH("allot_sale_bh", "销售补货调拨单"),

    BAIJIAN_DIRECT_SALES("baijian_direct_sales", "佰健直销"),

    ;

    private String code;

    private String desc;

    CsPcpBusinessTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsPcpBusinessTypeEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsPcpBusinessTypeEnum.values()).stream().filter(e -> {
            return e.getCode().equals(code);
        }).findAny().orElse(null);
    }

    /**
     * 入库/收货单是否要返回关联业务单入库仓库信息
     * 调拨单（除了内部交易）、采购促销物料入库、委外成品入库、生产成品入库、其他入库
     * 满足以上其中一个都需要返回关联业务单入库仓库信息
     *
     * @return true-要返回关联业务单信息，false-不用返回关联业务单信息
     */
    public static Boolean returnInWarehouseAddressBusinessType(String code) {
        return ALLOT_OUT.getCode().equals(code)
                || INSPECTION_QUALIFIED.getCode().equals(code)
                || PURCHASE.getCode().equals(code)
                || OUTSOURCE.getCode().equals(code)
                || PRODUCTION.getCode().equals(code)
                || OTHER_IN.getCode().equals(code)
                ;
    }

    /**
     * CC调拨、CB调拨、BC调拨单据编号集合
     * @return list
     */
    public static List<String> cAllotList(){
        return Lists.newArrayList(CC_ALLOT.getCode(),CB_ALLOT.getCode(), BC_ALLOT.getCode());
    }
}