package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 审核结果:audit_pass-审核通过,audit_failed-审核不通过
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsPlannedOrderAuditResultEnum {
    /**
     * 审核通过
     **/
    AUDIT_PASS("audit_pass", "审核通过"),
    /**
     * 审核不通过
     **/
    AUDIT_FAILED("audit_failed", "审核不通过"),
    ;

    private String code;

    private String desc;

    CsPlannedOrderAuditResultEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsPlannedOrderAuditResultEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsPlannedOrderAuditResultEnum.values()).stream().filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }
}
