package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 计划单商品行状态枚举
 * 商品行状态：正常-common，超收-overcharge，超收已解挂-relieve，异常-error
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsPlannedOrderItemStatusEnum {

    /**
     * 正常
     **/
    COMMON("common", "正常"),

    /**
     * 超收
     **/
    OVERCHARGE("overcharge", "超收"),

    /**
     * 超发
     **/
    DIFFERENCE("difference", "超发"),

    /**
     * 已解挂
     **/
    RELIEVE("relieve", "已解挂"),

    /**
     * 异常
     **/
    ERROR("error", "异常"),

    ;

    private String code;

    private String desc;

    CsPlannedOrderItemStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsPlannedOrderItemStatusEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsPlannedOrderItemStatusEnum.values()).stream().filter(e -> {
            return e.getCode().equals(code);
        }).findAny().orElse(null);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
