package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsPlannedOrderStatusEnum {

    /**
     * 待提交
     **/
    WAIT_SUBMIT("wait_submit", "待提交"),
    /**
     * 待审核
     **/
    WAIT_AUDIT("wait_audit", "待审核"),
    /**
     * 审核不通过
     **/
    AUDIT_FAILED("audit_failed", "审核不通过"),
    /**
     * 待入库
     **/
    WAIT_IN("wait_in", "待入库"),
    /**
     * 待出库
     **/
    WAIT_OUT("wait_out", "待出库"),
    /**
     * 已取消
     **/
    CANCEL("cancel", "已取消"),
    /**
     * 已关闭
     */
    CLOSED("closed", "已关闭"),
    /**
     * 部分入库
     **/
    PORTION_IN("portion_in", "部分入库"),
    /**
     * 部分入库
     **/
    PORTION_OUT("portion_out", "部分出库"),
    /**
     * 已完成
     **/
    COMPLETED("completed", "已完成"),
    /**
     * 挂起
     **/
    HANG_UP("hang_up", "挂起"),
    /**
     * 已完结
     **/
    FINISH("finish", "已完结"),
    ;

    private String code;

    private String desc;

    CsPlannedOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsPlannedOrderStatusEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsPlannedOrderStatusEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
