package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 单据类型枚举:purchase-采购订单,outsource-委外订单,production-生产订单
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsPlannedOrderTypeEnum {
    /**
     * 采购单据
     **/
    PURCHASE("purchase", "采购单据"),
    /**
     * 委外订单
     **/
    OUTSOURCE("outsource", "委外订单"),
    /**
     * 生产订单
     **/
    PRODUCTION("production", "生产订单"),
    /**
     * 采购退货单据
     **/
    PURCHASE_RETREAT("purchaseRetreat", "采购退货订单"),
    /**
     * 委外退货订单
     **/
    OUTSOURCE_RETREAT("outsourceRetreat", "委外退货订单"),

    /**
     * 生产返修退厂单
     */
    PRODUCT_REPAIR("productionRetreat", "生产返修退厂单");
    ;

    private String code;

    private String desc;

    CsPlannedOrderTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsPlannedOrderTypeEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsPlannedOrderTypeEnum.values()).stream().filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }
}
