package com.dtyunxi.yundt.cube.center.inventory.enums;

import io.swagger.annotations.ApiModelProperty;

/**
 * 基础单据（出/入库单、发/收货单）-业务单据表名枚举
 */
public enum CsRelevanceTableNameEnum {
    /**
     * 计划类正向入库单据
     */
    CS_IN_PLANNED_ORDER("cs_in_planned_order", "计划类正向入库单据", true),
    /**
     * 计划类逆向出库单据
     */
    CS_OUT_PLANNED_ORDER("cs_out_planned_order", "计划类逆向出库单据", true),
    /**
     * 批次调整单
     */
    CS_BATCH_ADJUSTMENT_ORDER("cs_batch_adjustment_order", "批次调整单", true),

    /**
     * 调整单
     */
    CS_ADJUSTMENT_ORDER("cs_adjustment_order", "调整单", true),
    /**
     * 盘点单
     */
    CS_INVENTORY_TAKE_STOCK_ORDER("cs_inventory_take_stock_order", "盘点单", true),
    /**
     * 其他出入库单
     */
    CS_OTHER_STORAGE_ORDER("cs_other_storage_order", "其他出入库单", true),
    /**
     * 调拨单
     */
    CS_TRANSFER_ORDER("cs_transfer_order", "调拨单", true),
    /**
     * 真实的表不存在，只是用来做兼容的
     **/
    CS_ORDER_SALE_REFUND("cs_order_sale_refund", "销售退", false),
    /**
     * 真实的表不存在，只是用来做兼容的
     **/
    CS_ORDER_SALE("cs_order_sale", "销售单", false),
    ;

    CsRelevanceTableNameEnum(String code, String desc, Boolean realTableExists) {
        this.code = code;
        this.desc = desc;
        this.realTableExists = realTableExists;
    }

    private String code;
    private String desc;
    @ApiModelProperty(name = "realTableExists", value = "库存中心是否存在真实表(true：存在，false：不存在)")
    private Boolean realTableExists;


    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Boolean getRealTableExists() {
        return realTableExists;
    }

    public static String getDescByCode(String code) {
        for (CsRelevanceTableNameEnum value : CsRelevanceTableNameEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }

    public static CsRelevanceTableNameEnum getStatusByCode(String code) {
        for (CsRelevanceTableNameEnum value : CsRelevanceTableNameEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}
