package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 分货单业务类型：manually_create：手工创建、procurement：采购分货
 *
 * @author 温仪
 * @version 1.0
 * @Date 2022/6/16 2:38 下午
 */
public enum CsShareGoodBusinessTypeEnum {
    /**
     * 手工创建
     **/
    MANUALLY_CREATE("manually_create", "手工创建"),
    /**
     * 采购分货
     **/
    PROCUREMENT("procurement", "采购分货"),
    ;

    private String code;

    private String desc;

    CsShareGoodBusinessTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (CsShareGoodBusinessTypeEnum value : CsShareGoodBusinessTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return StringUtils.EMPTY;
    }
}
