package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 分货单单据状态：wait_audit：待审核、completed：已完成、cancel：已取消、reject：已驳回
 *
 * @author 温仪
 * @version 1.0
 * @Date 2022/6/15 5:38 下午
 */
public enum CsShareGoodsOrderStatusEnum {
    /**
     * 待审核
     **/
    WAIT_AUDIT("wait_audit", "待审核"),
    /**
     * 已取消
     **/
    CANCEL("cancel", "已取消"),
    /**
     * 已完成
     **/
    COMPLETED("completed", "已完成"),
    /**
     * 已驳回
     **/
    REJECT("reject", "已驳回"),
    ;

    private String code;

    private String desc;

    CsShareGoodsOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (CsShareGoodsOrderStatusEnum value : CsShareGoodsOrderStatusEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return StringUtils.EMPTY;
    }
}
