package com.dtyunxi.yundt.cube.center.inventory.enums;

/**
 * @author jack
 * @version 1.0
 * @date 12/09/2022 01:35
 **/
public enum CsShipmentLogisticsTypeEnum {

   ZERO(0,"海柜"),
   ONE(1,"整车"),
   TWO(2,"零担"),
   LAND(3,"陆运"),
   STRAND(4,"标快"),
   PACKAGE(5,"快递包裹"),
   STAND(6,"标准快递"),
   QUICK(7,"特快专线"),
   OMS(8,"电商标快"),
   CARD(9,"顺丰卡航"),
   SF(10,"顺丰特快包裹"),
   SF_QUICK(11,"顺丰特快"),
   SF_STRAND(12,"顺丰标快"),
   TC(13,"TC物流"),
    ;

    private final Integer type;
    private final String desc;

    CsShipmentLogisticsTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        for (CsShipmentLogisticsTypeEnum value : values()) {
            if (value.getType().equals(type)) {
                return value.getDesc();
            }
        }
        return null;
    }

    public static CsShipmentLogisticsTypeEnum getEnumByName(String desc) {
        for (CsShipmentLogisticsTypeEnum value : values()) {
            if (value.getDesc().equals(desc)) {
                return value;
            }
        }
        return null;
    }
}
