package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 物流方式
 *
 * @author 初见
 * @version 1.0
 * @Date 2022/3/30 2:44 下午
 */
public enum CsShippingTypeEnum {

    /**
     * 陆运
     **/
    BY_LOAD("byLoad", "陆运"),

    /**
     * 海运
     **/
    BY_SEA("bySea", "海运"),

    /**
     * 空运
     **/
    BY_AIR("byAir", "空运"),

    /**
     * 整车
     **/
    CARLOAD("carload", "整车"),

    /**
     * 零担
     **/
    SINGLE("single", "零担"),
    ;

    /**
     * 编码
     **/
    private String code;

    /**
     * 描述
     **/
    private String desc;

    CsShippingTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsShippingTypeEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsShippingTypeEnum.values()).stream().filter(e -> {
            return e.getCode().equals(code);
        }).findAny().orElse(null);
    }
}
