package com.dtyunxi.yundt.cube.center.inventory.enums;

/**
 * <p>Title:CsOtherStorageOrderEnum</p>
 * <p>Description:</p>
 *
 * @author 无月
 * @date 2022/4/28 19:01
 */
public class CsTransferOrderEnum {

    public enum Status {

        /**
         * 待审核
         */
        WAIT_AUDIT("wait_audit", "待审核"),
        /**
         * 审核不通过
         */
        AUDIT_FAILED("audit_failed", "审核不通过"),
        /**
         * 待发货
         */
        WAIT_DELIVERY("wait_delivery", "待发货"),
        /**
         * 已发货
         */
        DELIVERED("delivered", "已发货"),
        /**
         * 部分出库
         */
        WAIT_RECEIVE("wait_receive", "待收货"),
        /**
         * 已完成
         */
        FINISH("finish", "已完成"),

        /**
         * 挂起
         */
        HANG_UP("hang_up", "挂起"),
        /**
         * 已取消
         */
        CANCELED("canceled", "已取消"),
        /**
         * 已关闭
         */
        CLOSED("closed", "已关闭"),
        /**
         * 部分收货
         */
        PORTION_RECEIVE("portion_receive", "部分收货"),
        /**
         * 部分发货
         */
        PORTION_DELIVERY("portion_delivery", "部分发货");

        private String code;

        private String desc;

        Status(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

}
