package com.dtyunxi.yundt.cube.center.inventory.enums;

public enum CsVersionDistinguishEnum {
    /**
     * V1.0版本
     **/
    FIRST(1, "V1.0版本"),
    /**
     * V2.0版本
     **/
    SECOND(2, "V2.0版本"),

    ;

    CsVersionDistinguishEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;
    private String desc;


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (CsVersionDistinguishEnum value : CsVersionDistinguishEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }

    public static CsVersionDistinguishEnum getStatusByCode(String code) {
        for (CsVersionDistinguishEnum value : CsVersionDistinguishEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}
