package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 仓库类型分类，主要包含四层：物理仓、逻辑仓、虚拟仓、渠道仓
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 2:44 下午
 */
public enum CsWarehouseClassifyEnum {

    /**
     * 物理仓
     **/
    PHYSICS("physics", "物理仓"),

    /**
     * 逻辑仓
     **/
    LOGIC("logic", "逻辑仓"),

    /**
     * 虚拟仓
     **/
    VIRTUAL("virtual", "虚拟仓"),

    /**
     * 渠道仓
     **/
    CHANNEL("channel", "渠道仓"),

    /**
     * 在途仓
     **/
    IN_TRANSIT("in_transit", "在途仓"),
    ;

    /**
     * 编码
     **/
    private String code;

    /**
     * 描述
     **/
    private String desc;

    CsWarehouseClassifyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsWarehouseClassifyEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return Arrays.asList(CsWarehouseClassifyEnum.values()).stream().filter(e -> {
            return e.getCode().equals(code);
        }).findAny().orElse(null);
    }
}
