package com.dtyunxi.yundt.cube.center.inventory.enums;

/**
 * 公用mq类型枚举类
 *
 * @author wuyue
 * @since 2022-05-12
 */
public class MqMessageEnum {

    public enum Type {
        /**
         * 出入库通知单
         */
        OUT_IN_NOTICE_ORDER(11, "出入库通知单"),
        /**
         * 收发货结果单
         */
        RECEIVE_DELIVERY_RESULT_ORDER(12, "收发货结果单");

        private Integer type;
        private String desc;


        Type(Integer type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public enum Status {


        /**
         * 发送mq失败
         */
        SEND_FAILED(0, "发送mq失败"),
        /**
         * 发送mq成功
         */
        SEND_SUCCESS(1, "发送mq成功"),
        /**
         * 创建单据失败
         */
        CREATE_FAILED(2, "创建单据失败"),
        /**
         * 创建单据成功
         */
        CREATE_SUCCESS(3, "创建单据成功");

        private Integer type;
        private String desc;


        Status(Integer type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

