package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

public enum WarehouseCorrespondingSystemEnum {

    E3_MY("e3_my","E3麦优"),
    E3_BS("e3_bs","E3百胜"),

    ;

    private String code;

    private String desc;

    WarehouseCorrespondingSystemEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static WarehouseCorrespondingSystemEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.stream(WarehouseCorrespondingSystemEnum.values()).filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }
}
