/**
 * @(#)UserExceptionCode.java 1.0 2016-11-10
 * <p>
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.exception;

/**
 * 库存中心异常码描述
 *
 * @author jinger
 * @since 1.0.0
 */
public enum CsInventoryExceptionCode {
    SUCCESS_CODE("0", "success"),
    PARAM_ERROR("100000", "参数错误"),
    PARAM_LOCK("100000", "参数缺失"),
    INVENTORY_EXCEPTION("100001", "出/入库库存操作异常，不存在该操作"),
    INVENTORY_NOT_ENOUGH("100002", "库存不足，预占失败"),
    INVENTORY_NOT_PREEMPT("100002", "预占记录不存在，库存释放失败"),
    INVENTORY_IS_NEGATIVE("100003", "初始化库存数量不能为负数"),
    NO_FOUND_PREEMPT_RECORD("100004", "查询不到预占记录"),
    INVENTORY_IS_NOT_EXIST("100005", "货品库存不存在"),


    EXIST_PRE_ORDER("304", "已存在流转正常的前置单据"),
    OPERATION_NOT_EXIST("1001", "操作异常，不存在该操作"),
    DELIVERY_NOTICE_NOT_EXIST("1002", "前置单据关联的发货通知单不存在"),
    OPERATION_ERROR_DOCUMENT("1003", "操作异常，不存在该操作,单据当前状态为："),
    UPDATE_STATUS_NOT_EXIST("1004", "变更状态不存在"),
    PRE_ORDER_IS_NULL("1005", "前置单据号为空"),
    PRE_ORDER_RELEVANCE_ITEM_IS_NULL("1006", "前置单据关联的商品信息为空"),

    DOCUMENT_ALWAYS_OUT("3202", "单据已通知出库，不能更新批次"),

    ;



    private final String code;

    private final String msg;

    private CsInventoryExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;

    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }
}
