package com.dtyunxi.yundt.cube.center.inventory.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wufan
 */
@Data
public class OperationDetailParam implements Serializable {

    @ApiModelProperty(name = "warehouseId", value = "仓库ID（逻辑）, 当 OnlyPhysics = true 时，为物理仓ID")
    private Long warehouseId;

    @ApiModelProperty(name = "warehouseCode", value = "仓库Code（逻辑）, 当 OnlyPhysics = true 时，为物理仓Code")
    private String warehouseCode;

    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "num", value = "操作库存数量")
    private BigDecimal num;

    @ApiModelProperty(name = "batch", value = "货品批次")
    private String batch;

    @ApiModelProperty(name = "batchType", value = "批次类型")
    private String batchType;

    @ApiModelProperty(name = "expireTime", value = "过期时间")
    private Date expireTime;

    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

}
