package com.dtyunxi.yundt.cube.center.inventory.param;

import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 库存中心，操作库存参数类，控制库存变化核心入参
 * @author wufan
 */
@Data
public class OperationParam implements Serializable {

    public static final int RETRY_TIMES = 5;

    public static final long RETRY_DELAY = 1800;

    private String desc;

    @ApiModelProperty(name="sourceNo",value = "来源单据号")
    private String sourceNo;

    @ApiModelProperty(name="sourceType",value = "来源单据类型")
    private String sourceType;

    @ApiModelProperty(name="businessType",value = "来源业务类型")
    private String businessType;

    @ApiModelProperty(name="remark",value = "备注信息")
    private String remark;

    @ApiModelProperty(name="flag",value = "出入库标识  in-入库  out-出库")
    private String flag;

    @ApiModelProperty(name="coverInventoryFlag",value = "是否覆盖原有库存 cover-覆盖  update-更新(默认)")
    private String coverInventoryFlag = CsInventoryCoverInventoryFlagEnum.UPDATE.getCode();

    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;

    /**
     * 操作货品数量为0时是否报错，默认报错，为false时会进行忽略
     */
    private Boolean zeroError = Boolean.TRUE;

    /**
     * 是否允许批次号为空
     */
    private Boolean noneBatch = Boolean.FALSE;

    /**
     * 是否指定批次
     */
    private Boolean shoutBatch = Boolean.TRUE;

    /**
     * 查询货品是否通过ID
     */
    private Boolean isSearchCargoById = Boolean.TRUE;

    /**
     * 查询仓库是否通过ID
     */
    private Boolean isSearchWarehouseById = Boolean.TRUE;

    private Boolean doLogic = Boolean.TRUE;

    private Boolean doPhysics = Boolean.TRUE;

    /**
     * 操作货品明细
     */
    private List<OperationDetailParam> details;

    public String getDescRemark() {
        return StringUtils.isNotBlank(this.remark) ? this.remark + String.format("[%s]", this.desc) : this.desc;
    }

}
