package com.dtyunxi.yundt.cube.center.inventory.param;

import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 出库参数
 * @author wufan
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OutParam extends OperationParam{
    private static final String DESC = "出库";

    public OutParam () {
        this.setDesc(DESC);
        this.setFlag(CsInventoryInOutEnum.OUT.getCode());
    }

    /**
     * 是否允许可用库存小于0
     */
    private Boolean isAvailableLowerZero = Boolean.FALSE;

    /**
     * 是否允许实际库存小于0
     */
    private Boolean isBalanceLowerZero = Boolean.FALSE;

}
